//Modulation and Demodulation of Binary Phase Shift Keying over Additive White Gaussian Noise (AWGN) channel
// OS-Windows 10
// Scilab 6.1.0
// Course Instructor Name: Dr. V. A. Sankar Ponnapalli
// Institute Name: ICFAI Foundation for Higher Education Hyderabad


clear; 
clc;
close;

l = input("Enter number of bits to transmit (Choose between: 100000 to 1000000): ");
while l < 100000 | l > 1000000
    l = input("Invalid input. Enter number of bits between 100000 and 1000000: ");
end

EbNodB = 0:2:10;              // Range of Eb/No in dB
BER = zeros(1, length(EbNodB));  // Initialize BER array

// Pick example Eb/N0 for printing outputs (middle of range)
example_idx = floor(length(EbNodB)/2);
example_EbNodB = EbNodB(example_idx);

for n = 1:length(EbNodB)
    // Generate random BPSK symbols: -1 or 1
    s = 2*(round(rand(1, l))-0.5);
    
    // AWGN noise with variance based on Eb/N0
    noise_std = 1/sqrt(2*10^(EbNodB(n)/10));
    w = noise_std * rand(1, l, 'normal');
    
    // Received signal
    r = s + w;
    
    // Demodulation: sign detector
    s_est = sign(r);
    
    // BER calculation
    BER(n) = sum(s ~= s_est)/l;
    
    // Save example bits for display
    if n == example_idx then
        bits_sent = (s + 1)/2;      // convert from -1/1 to 0/1 for clarity
        bits_demod = (s_est + 1)/2;
    end
end

// Display example output for the chosen Eb/N0
disp("Example Eb/N0 (dB): " + string(example_EbNodB));
disp("First 50 generated bits (0/1):");
disp(bits_sent(1:50));
disp("First 50 demodulated bits (0/1):");
disp(bits_demod(1:50));

// Plot BER vs Eb/N0
scf();
semilogy(EbNodB, BER, 'o-');
xlabel('Eb/No (dB)');
ylabel('Bit Error Rate (BER)');
title('BER Performance of BPSK over AWGN Channel');

//// Description of the Figure
// User Inputs:
// Enter number of bits to transmit (Choose between: 100000 to 1000000): 1e6
// The figure titled "BER Performance of BPSK over AWGN Channel" illustrates how BPSK performs over AWGN. 

